<?php


class course_controller extends default_controller {

	public $tab;

	public function __construct($strPageId) {

		$this->strSortBy = 'edit_date';
		$this->strSortOrder = 'DESC';
		
		$this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];

		parent::__construct($strPageId);

		$this->strTableName = 'course';
		$this->strAdminSlug = '/admin/course/';
		$this->tab = isset($_REQUEST['tab']) ? $_REQUEST['tab'] : '';

		$this->arrTableSQLArray = array('','course_name','state_name','edit_date','');
		$this->arrTableDisplayArray = array('<input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);">','Name','State','Modified','SEO Score');
		$this->arrTableSortArray = array(false,true,true,true,true);

		$this->strOptions = '?searchWord='.$this->strSearchWord . '&amp;status='.$this->strStatus;

		$this->arrCategories = $this->objModel->getCategories();

		if(!isset($this->page['id'])) {
			$this->page['country_id'] = 261;
			$this->page['state_id'] = 2;
			$this->arrImages = Null;
			$this->arrVideos = Null;
			$this->page['slug'] = '/detail/course/';

		} else {
			$this->arrDocs = $this->objModel->getCourseDocList($this->page['id']);
			$this->arrImages = $this->objModel->getCourseImageList($this->page['id']);
			$this->arrVideos = $this->objModel->getCourseVideoList($this->page['id']);
			$this->arrReviews = $this->objModel->getCourseReviewList($this->page['id'],false);
			$this->arrTestimonials = $this->objModel->getCourseTestimonialList($this->page['id'],false);
			$this->page['slug'] = '/detail/course/'.$this->page['slug'];
		}


		if($this->page['country_id'] == Null) {
			$this->page['country_id'] = 261;
			$this->page['state_id'] = 2;
		}

		$this->objLocation = new Location;
		$this->arrCountries = $this->objLocation->getCountries();
		$this->arrStates = $this->objLocation->getStates($this->page['country_id']);
		$this->arrCities = $this->objLocation->getCities($this->page['state_id']);


		if($this->strAction == '') {
			$this->strView =   'list_courses';
		} else {
			$this->strView =   'course_form';

			//Util::debugDisplay($this->page);
		}

		if (($this->page['slug'] == '/detail/course/') && (isset($_REQUEST['export'])) && ($_REQUEST['export'] == 'Export As CSV')) {

			$arrRecords = $this->objModel->getCourseExport();
			$arrOutput = array();

			foreach ($arrRecords as $arrRecord) {
				$arrTemp = array(
					'id' => $arrRecord['id'],
					'course_name' =>$arrRecord['course_name'],
					//'course_type' =>$arrRecord['course_type'],
					'hits' =>$arrRecord['hit_counter'],
					'course_level' =>$arrRecord['level'],
					'country' => $arrRecord['country_name'],
					'state' =>$arrRecord['state_name'],
					'city' =>$arrRecord['city_name'],
					'address' =>$arrRecord['address'],
					'postal_code' =>$arrRecord['zip'],
					'lat' =>$arrRecord['latitude'],
					'lng' =>$arrRecord['longitude'],
					//'tee_boxes' =>$arrRecord['id'],
					//'9holes' =>$arrRecord['id'],
					//'18holes' =>$arrRecord['id'],
					'gm' =>$arrRecord['gm'],
					'seasonal'=>$arrRecord['seasonal'],
					'holes'=>$arrRecord['holes'],
					'course_par'=>$arrRecord['course_par'],
					'course_superintendent'=>$arrRecord['course_superintendent'],
					'course_architects'=>$arrRecord['course_architects'],
					'course_a_comments'=>$arrRecord['course_a_comments'],
					'booking_url'=>$arrRecord['booking_url'],
					'booking_username'=>$arrRecord['booking_username'],
					'contact_email'=>$arrRecord['contact_email'],
					'type_name'=>$arrRecord['type_name'],
					'focus_keyword'=>$arrRecord['focus_keyword'],
					'meta_title'=>$arrRecord['meta_title'],
					'meta_keywords'=>$arrRecord['meta_keywords'],
					'meta_description'=>$arrRecord['meta_description'],
					'testimonial' => $arrRecord['testimonial'],

					);

				$arrOutput[] = $arrTemp;
			}

			$output = fopen("php://output",'w+') or die("Can't open php://output");

			header("Content-Type:application/csv");
			header("Content-Disposition:attachment;filename=course_export.csv");

			fputcsv($output,
				array(	'id','course_name','hits','course_level','country','state','city',
						'address','postal_code','lat','lng','gm','seasonal','holes','course_par','course_superintendent','course_architects',
						'course_a_comments','booking_url','booking_username','contact_email','type_name','focus_keyword','meta_title',
						'meta_keywords','meta_description','testimonial'
					)
				);
			foreach($arrOutput as $arrOut) {
			    fputcsv($output, $arrOut);
			}

			fclose($output) or die("Can't close php://output");
			die();

		}

	}


	/**
	 * Function that sets our Model for the controller
	 *
	 */
	public function setModel($strPageId, $strAction) {

		$this->objModel = New Course($strPageId, $strAction);

	}

	/**
	 * Function that creates the list of actions the user can do to the record
	 * Edit, Restore, Trash, Delete
	 */
	public function getPageControls($id, $slug, $status, $visible = true, $guid = '') {
		$html = '';
		$visibleClass = ($visible) ? '' : 'invisible';

		$html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';

        if ($guid != '') {
            $html .= '<li><a target="_blank" href="/application/cron/viewDetailReportCourse.php?guid='. $guid . '">View Detail Weekly Report emailer</a></li>';
            $html .= '<li><a target="_blank" href="/application/cron/viewDetailReportCoursePrint.php?guid='. $guid . '">View full Calendar Detail Report</a></li>';
        }

		if ($status == 'Trash') {
			$html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/' . $this->strOptions . '">Restore</a></li>';
			$html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Permanently Delete</a></li>';
		} else {
		    if($this->objModel->checkpageaccess($_REQUEST['controller'], 'edit')){
			$html .= '<li><a href="'.$this->strAdminSlug.'edit/' . $id . '/' . $this->strOptions . '">Edit</a></li>';
		    }
			if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
			    $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Trash</a></li>';
			}
		}
		$html .= '</ul>';

		return $html;
	}


}



?>