<?php


class city_controller extends default_controller {

	public function __construct($strPageId) {



		$this->strSortBy = 'state_id ASC, title';
		$this->strSortOrder = 'ASC';
		
		$this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];

		parent::__construct($strPageId);

		$this->strTableName = 'city';
		$this->strAdminSlug = '/admin/city/';

		$this->arrTableSQLArray = array('','title','state_id');
		$this->arrTableDisplayArray = array('<input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);">','City Name','State');
		$this->arrTableSortArray = array(false,true,true);

		$this->strOptions = '?searchWord='.$this->strSearchWord . '&amp;status='.$this->strStatus;

		$this->arrStates = $this->objModel->getStates();

		if($this->strAction == '') {
			$this->strView =   'list_cities';
		} else {
			$this->strView =   'city_form';
		}
	}


	/**
	 * Function that sets our Model for the controller
	 *
	 */
	public function setModel($strPageId, $strAction) {

		$this->objModel = New City($strPageId, $strAction);

	}

	/**
	 * Function that creates the list of actions the user can do to the record
	 * Edit, Restore, Trash, Delete
	 */
	public function getPageControls($id, $slug, $status, $visible = true) {
		$html = '';
		$visibleClass = ($visible) ? '' : 'invisible';

		$html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';
		if ($status == 'Trash') {
			$html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/' . $this->strOptions . '">Restore</a></li>';
			$html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Permanently Delete</a></li>';
		} else {
		    if($this->objModel->checkpageaccess($_REQUEST['controller'], 'edit')){
			$html .= '<li><a href="'.$this->strAdminSlug.'edit/' . $id . '/' . $this->strOptions . '">Edit</a></li>';
		    }
			if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
			    $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Trash</a></li>';
			}
		}
		$html .= '</ul>';

		return $html;
	}


}



?>