<?php


class brand_controller extends default_controller {

	public function __construct($strPageId) {


		$this->strSortBy = 'business_name';
		$this->strSortOrder = 'ASC';
		
		$this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];

		parent::__construct($strPageId);

		$this->strTableName = 'brands';
		$this->strAdminSlug = '/admin/brand/';
		$this->tab = isset($_REQUEST['tab']) ? $_REQUEST['tab'] : '';

		$this->arrTableSQLArray = array('','thumb','business_name','region_name','state_name');
		$this->arrTableDisplayArray = array('<input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);">','Logo','Name','Region','State');
		$this->arrTableSortArray = array(false,false,true,true,true);

		$this->strOptions = '?searchWord='.$this->strSearchWord . '&amp;status='.$this->strStatus;
		$this->arrCourses = array();

		if($this->strAction != ''){
			$this->objLocation = new Location;
			$this->arrRegions = $this->objLocation->getRegions();
			$this->arrCountries = $this->objLocation->getCountries();
			$this->arrStates = $this->objLocation->getStates($this->objModel->intCountryId);
			$this->arrCities = $this->objLocation->getCities($this->objModel->intStateId);
			$this->arrCourses = $this->objModel->getCourses($this->intID);
			$this->arrHotels = $this->objModel->getHotels($this->intID);
			$this->arrBookingPeople = $this->objModel->getBookingPeople($this->intID);



			//var_dump($this->arrCourses);
		}

		if($this->strAction == '') {
			$this->strView =   'list_brands';
		} else {
			$this->strView =   'brand_form';
		}


	}


	/**
	 * Function that sets our Model for the controller
	 *
	 */
	public function setModel($strPageId, $strAction) {

		$this->objModel = New Brand($strPageId, $strAction);

	}

	/**
	 * Function that creates the list of actions the user can do to the record
	 * Edit, Restore, Trash, Delete
	 */
	public function getPageControls($id, $slug, $status, $visible = true) {
		$html = '';
		$visibleClass = ($visible) ? '' : 'invisible';

		$html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';
		if ($status == 'Trash') {
			$html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/' . $this->strOptions . '">Restore</a></li>';
			$html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Permanently Delete</a></li>';
		} else {
		    if($this->objModel->checkpageaccess($_REQUEST['controller'], 'edit')){
			$html .= '<li><a href="'.$this->strAdminSlug.'edit/' . $id . '/' . $this->strOptions . '">Edit</a></li>';
		    }
			if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
			    $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Trash</a></li>';
			}
		}
		$html .= '</ul>';

		return $html;
	}


}



?>