<?php

include("config.php");

$action = !empty($_REQUEST['action']) ? $_REQUEST['action'] : '';

if($action == 'getProvs') {

	//http://bcgolfguide.nav/application/ajax.php?action=getProvs&country=261
	$country = (isset($_REQUEST['country']) ? $_REQUEST['country'] : '');
	$location = new Location;
	$prov_array = $location->getStates($country);
	echo json_encode($prov_array);


} else if($action == 'update_paidout') {

	$newval = (isset($_REQUEST['newval']) ? $_REQUEST['newval'] : '');
	$Index = (isset($_REQUEST['Index']) ? $_REQUEST['Index'] : '');
	$type = (isset($_REQUEST['type']) ? $_REQUEST['type'] : '');

	include(ROOT_DIR.'/application/models/admin/package.php');
	$objPackage = new Package;
	echo $objPackage->savePaidStatus($newval,$type,$Index);


} else if($action == 'getCities') {
	//http://bcgolfguide.nav/application/ajax.php?action=getCities&prov=32
	$prov = (isset($_REQUEST['prov']) ? $_REQUEST['prov'] : '');
	$location = new Location;
	$city_array = $location->getCities($prov);
	echo json_encode($city_array);

} else if($action == 'getRegionsForCountry') {

	$country = (isset($_REQUEST['country']) ? $_REQUEST['country'] : '');
	$location = new Location;
	$region_array = $location->getRegionsByCountry($country);
	echo json_encode($region_array);

} else if($action == 'updatePackageStatus') {

	$packageID = (isset($_REQUEST['packageID']) ? $_REQUEST['packageID'] : '');
	$stat = (isset($_REQUEST['stat']) ? $_REQUEST['stat'] : '');
	if($stat != '' && $packageID != '') {
		include(ROOT_DIR.'/application/models/admin/package.php');
		$objPackage = new Package;
		echo $objPackage->updateCompleted($packageID,$stat);
	}
	//$sql = "UPDATE packages SET completed=$stat WHERE id=$packageID";

	//echo '$sql='.$sql;

} else if($action == 'updateCourseRegion') {

	$val = (isset($_REQUEST['val']) ? $_REQUEST['val'] : '');
	$region = (isset($_REQUEST['region']) ? $_REQUEST['region'] : '');
	$check = (isset($_REQUEST['check']) ? $_REQUEST['check'] : '');

	//http://bcgolfguide.nav/application/ajax.php?action=updateCourseRegion&val=7&region=63&check=true
	include(ROOT_DIR.'/application/models/admin/region.php');
	$objRegion = new Region;
	$result = $objRegion->updateCourseRegion($region,$val,$check);
	//$result = array('Region:'.$region , 'Check:'.$check, 'Val:'.$val);
	echo json_encode($result);

} else if($action == 'updateHotelRegion') {

	$val = (isset($_REQUEST['val']) ? $_REQUEST['val'] : '');
	$region = (isset($_REQUEST['region']) ? $_REQUEST['region'] : '');
	$check = (isset($_REQUEST['check']) ? $_REQUEST['check'] : '');

	//http://bcgolfguide.nav/application/ajax.php?action=updateCourseRegion&val=7&region=63&check=true
	include(ROOT_DIR.'/application/models/admin/region.php');
	$objRegion = new Region;
	$result = $objRegion->updateHotelRegion($region,$val,$check);
	//$result = array('Region:'.$region , 'Check:'.$check, 'Val:'.$val);
	echo json_encode($result);

} else if($action == 'special') {

	//http://bcgolfguide.nav/application/ajax.php?action=special
	include(ROOT_DIR.'/application/models/admin/region.php');
	$objRegion = new Region;



	$arrRegions = $objRegion->getRegions();
	foreach($arrRegions As $r) {

		$arrCourses = $objRegion->getCoursesForRegion($r['id']);


		foreach($arrCourses As $c) {
			$result = $objRegion->updateCourseRegion($r['id'],$c['id'],'true');
			echo $result.'<br />';
		}


	}


} else if($action == 'special2') {

	//http://bcgolfguide.nav/application/ajax.php?action=special2
	include(ROOT_DIR.'/application/models/admin/region.php');
	$objRegion = new Region;



	$arrRegions = $objRegion->getRegions();
	foreach($arrRegions As $r) {

		$arrCourses = $objRegion->getHotelsForRegion($r['id'],false);
		foreach($arrCourses As $c) {
			$result = $objRegion->updateHotelRegion($r['id'],$c['id'],'true');
			//echo $result.'<br />';
		}


	}

} else if($action == 'getBrandMiniInfo') {

	//http://bcgolfguide.nav/application/ajax.php?action=getBrandMiniInfo&brandID=18

	$brandID = (isset($_REQUEST['brandID']) ? $_REQUEST['brandID'] : '');
	$packageID = (isset($_REQUEST['packageID']) ? $_REQUEST['packageID'] : '');

	if($brandID != '') {

		$content = '';

		include(ROOT_DIR.'/application/models/admin/brand.php');
		include(ROOT_DIR.'/application/models/admin/package.php');

		$objBrand = new Brand;

		$result= $objBrand->getMiniDetail($brandID);
		$content = $result['mini_email_text'];

		$objPackage = new Package;
		$client =  $objPackage->getClientNameForPackage($packageID);
		$session = $objPackage->getSessionForPackage($packageID);

		$content = str_replace('[client_name]',$client,$content);

		if($session != '') {
			$url = ROOT_URL.'/package/'.$session.'/';
			$content = str_replace('[mini_url]',$url,$content);
		}


		//var_dump($result);
		echo $content;
	}

} else if($action == 'getBrandMiniQuoteInfo') {

	//http://bcgolfguide.nav/application/ajax.php?action=getBrandMiniInfo&brandID=18

	$brandID = (isset($_REQUEST['brandID']) ? $_REQUEST['brandID'] : '');
	$quoteID = (isset($_REQUEST['quoteID']) ? $_REQUEST['quoteID'] : '');

	if($brandID != '') {

		$content = '';

		include(ROOT_DIR.'/application/models/admin/brand.php');
		// include(ROOT_DIR.'/application/models/admin/quote.php');

		$objBrand = new Brand;

		$result= $objBrand->getMiniDetail($brandID);
		$content = $result['mini_quote_email_text'];

		$objQuote = new Quote;
		$client =  $objQuote->getClientNameForQuote($quoteID);
		$session = $objQuote->getSessionForQuote($quoteID);

		$content = str_replace('[client_name]',$client,$content);

		if($session != '') {
			$url = ROOT_URL.'/quote-preview/'.$session.'/';
			$content = str_replace('[mini_url]',$url,$content);
		}


		//var_dump($result);
		echo $content;
	}

} else if($action == 'getBrandVoucherInfo') {

	//http://bcgolfguide.nav/application/ajax.php?action=getBrandVoubherInfo&brandID=18

	$brandID = (isset($_REQUEST['brandID']) ? $_REQUEST['brandID'] : '');
	$packageID = (isset($_REQUEST['packageID']) ? $_REQUEST['packageID'] : '');

	if($brandID != '') {

		$content = '';

		include(ROOT_DIR.'/application/models/admin/brand.php');
		include(ROOT_DIR.'/application/models/admin/package.php');

		$objBrand = new Brand;

		$result= $objBrand->getMiniDetail($brandID);
		$content = $result['voucher_email_text'];

		$objPackage = new Package;
		$client =  $objPackage->getClientNameForPackage($packageID);
		$session = $objPackage->getSessionForPackage($packageID);

		$content = str_replace('[client_name]',$client,$content);

		if($session != '') {
			$url = ROOT_URL.'/package/'.$session.'/';
			$content = str_replace('[mini_url]',$url,$content);
		}


		//var_dump($result);
		echo $content;
	}


} else if($action == 'getTeeTimeUpdateEmail') {

	//http://bcgolfguide.nav/application/ajax.php?action=getBrandVoubherInfo&brandID=18

	$intPackageCourseId = (isset($_REQUEST['packageCourseID']) ? $_REQUEST['packageCourseID'] : '');

	if(empty($intPackageCourseId)){
		// no record to find
		return;
	}

	$content = '';

	include(ROOT_DIR.'/application/models/admin/brand.php');

	$objBrand = new Brand;

	// get brand id
	$strSQL = "SELECT `p`.`brandID`
				 FROM `packages` `p`
				WHERE `p`.`id` = (
					SELECT `pg`.`package_id`
					FROM `package_golf` `pg`
					WHERE `pg`.`id` = $intPackageCourseId
				)";

	$arrResults = $objBrand->getMysqliResults($strSQL, true);
	$intBrandId = $arrResults[0]['brandID'];

	$arrResults = $objBrand->getDetail($intBrandId);

	$content = $arrResults['course_teetimes_update_email'];

	//var_dump($result);
	echo $content;

} else if($action == 'getBrandHotelMiniInfo') {

	//http://preview.bcgolfguide.com/application/ajax.php?action=getBrandHotelMiniInfo&brandID=18&packageID=8414

	$brandID = (isset($_REQUEST['brandID']) ? $_REQUEST['brandID'] : '');
	$packageID = (isset($_REQUEST['packageID']) ? $_REQUEST['packageID'] : '');

	if($brandID != '') {

		$content = '';

		include(ROOT_DIR.'/application/models/admin/brand.php');
		include(ROOT_DIR.'/application/models/admin/package.php');

		$objBrand = new Brand;

		$result= $objBrand->getMiniDetail($brandID);
		$content = $result['mini_hotel_text'];

		$objPackage = new Package;

		$details =  $objPackage->getHotelDetailsForPackage($packageID);

		$session = $objPackage->getSessionForPackage($packageID);

		$content = str_replace('[group_name]',$details['group_name'],$content);

		if($session != '') {
			$url = ROOT_URL.'/package/'.$session.'/';
			$content = str_replace('[mini_url]',$url,$content);
		}


		//var_dump($result);
		echo $content;

		//var_dump($details);

	}

} else if($action == 'getBrandText') {

	//http://bcgolfguide.nav/application/ajax.php?action=getBrandMiniInfo&brandID=18

	$brandID = (isset($_REQUEST['brandID']) ? $_REQUEST['brandID'] : '');
	$ident = (isset($_REQUEST['ident']) ? $_REQUEST['ident'] : '1');

	if($brandID != '') {

		$content = '';

		include(ROOT_DIR.'/application/models/admin/brand.php');
		//include(ROOT_DIR.'/application/models/admin/package.php');

		$objBrand = new Brand;

		$result= $objBrand->getMiniDetail($brandID);
		$content = $result['voucher_text_'.$ident];

		//$objPackage = new Package;
		//$client =  $objPackage->getClientNameForPackage($packageID);
		//$session = $objPackage->getSessionForPackage($packageID);

		//$content = str_replace('[client_name]',$client,$content);

		//if($session != '') {
			//$url = ROOT_URL.'/package/'.$session.'/';
			//$content = str_replace('[mini_url]',$url,$content);
		//}


		//var_dump($result);
		echo $content;
	}
} else if($action == 'getHotelSpecial') {

    $packageID = (isset($_REQUEST['packageID']) ? $_REQUEST['packageID'] : '');

    if($packageID != '') {

        $content = '';

        //include(ROOT_DIR.'/application/models/admin/brand.php');
        include(ROOT_DIR.'/application/models/admin/package_hotel.php');

        $objPackageHotel = new Packagehotels;

        $result= $objPackageHotel->getHotelsByPackage($packageID);

        foreach ($result as $arrHotel) {
            if ($arrHotel['special_instructions'] != '')  {
                $content .= $arrHotel['special_instructions'] . "\n";
            }
        }

        echo $content;
    }
} else if($action == 'sendNote') {

	//http://bcgolfguide.nav/application/ajax.php?action=sendNote&packageID=7904&note=test

	$note = (isset($_REQUEST['note']) ? $_REQUEST['note'] : '');
	$quoteGroupID = (isset($_REQUEST['groupID']) ? $_REQUEST['groupID'] : '');
	$quoteID = (isset($_REQUEST['quoteID']) ? $_REQUEST['quoteID'] : '');
    $packageID = (isset($_REQUEST['packageID']) ? $_REQUEST['packageID'] : '');

	if($note != '') {

        if (!empty($packageID)) {
            include(ROOT_DIR.'/application/models/admin/package.php');
            $objPackage = new Package;

            // Add the note to the package, get the contact emails, get the note history
            $objPackage->setPackageNote($packageID, $note);
            $objPackage->sendPackageNoteAlert($packageID, $note);
            $arrNoteHistory = $objPackage->getNotesForPackage($packageID);
        } else {
            $objQuote = new Quote;

            // Add the note to the quote, get the contact emails, get the note history
            $objQuote->setQuoteNote($quoteGroupID, $note);
            $objQuote->sendQuoteNoteAlert($quoteID, $note);
            $arrNoteHistory = $objQuote->getNotesForQuoteGroup($quoteGroupID);
        }

        $arrData = array();

        if (!empty($arrNoteHistory)) {
            foreach($arrNoteHistory As $mrow){
            	if ($mrow['direction'] == '1') {
    				if ($mrow['sales_id'] == '1') {
    					$sender = 'Ross Marrington';
    				}
    				if ($mrow['sales_id'] == '2') {
    					$sender = 'Danny Leitch';
    				}
    			} else {
    				$sender = $mrow['user_name'];
    			}

            	$arrData[] = array(
            		'id' => !empty($mrow['id']) ? $mrow['id'] : '',
            		'direction' => !empty($mrow['direction']) ? $mrow['direction'] : '',
            		'group_id' => !empty($mrow['group_id']) ? $mrow['group_id'] : '',
            		'comment' => !empty($mrow['comment']) ? $mrow['comment'] : '',
            		'timestamp' => !empty($mrow['timestamp']) ? Date('Y-m-d',strtotime($mrow['timestamp'])) : '',
            		'sales_id' => !empty($mrow['sales_id']) ? $mrow['sales_id'] : '',
            		'contact_person' => $sender,
            		'user_name' => !empty($mrow['user_name']) ? $mrow['user_name'] : '',
            	);
    		}
        }

        echo json_encode($arrData);
        die;
	}

}else if($action == 'sendPackageLink') {

	//http://bcgolfguide.nav/application/ajax.php?action=sendPackageLink&packageID=8256&mini_content=test

	$mini_content = (isset($_REQUEST['mini_content']) ? $_REQUEST['mini_content'] : '');
    $mini_content = wordwrap($mini_content, 900);
	$packageID = (isset($_REQUEST['packageID']) ? $_REQUEST['packageID'] : '');
    $additionalEmails = (isset($_REQUEST['additionalEmails']) ? $_REQUEST['additionalEmails'] : '');
    $arrAdditionalEmails = explode(',',$additionalEmails);

	if($mini_content != '') {
		include(ROOT_DIR.'/application/models/admin/package.php');
		include(ROOT_DIR.'/application/models/admin/brand.php');

		$objPackage = new Package;
		$objBrand = new Brand;

		$arrAgents =  $objPackage->getEmailsForPackage($packageID);
        $arrPackageMembers = $objPackage->getPrimaryPackageHotelDetail($packageID);
		$blnUserEmailSent = false;

		$strPrimaryContact = 'Ross Marrington';
		$strPrimaryContactEmail = 'ross@bcgolfguide.com';

		foreach ($arrAgents AS $arrAgent) {
			if ($arrAgent['primary_contact'] == '1') {
				$strPrimaryContact = $arrAgent['booking_name'];
				$strPrimaryContactEmail = $arrAgent['booking_email'];
			}
		}

		$semi_rand     = md5(time());
		$mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";
    	$headers = "From: ".$strPrimaryContactEmail. "\r\n" .
    		'Reply-To: '.$strPrimaryContactEmail. "\r\n" .
    		'Content-Type: text/html; charset=UTF-8' . "\r\n" .
    		'X-Mailer: PHP/' . phpversion();

		foreach ($arrAgents AS $arrAgent) {

			$arrBrand = $objBrand->getDetail($arrAgent['brandID']);
        	$subject = 'Message from ' . $arrBrand['business_name'];

			if (!$blnUserEmailSent) {
				Util::sendMailCore($arrAgent['user_email'], $subject, $mini_content, $headers);

                if (!empty($arrAdditionalEmails)) {
                    foreach ($arrAdditionalEmails AS $intPackageHotelMemberId) {
                        foreach ($arrPackageMembers AS $arrPackageMember) {
                            if ($intPackageHotelMemberId == $arrPackageMember['id']) {
                                Util::sendMailCore($arrPackageMember['people_email'], $subject, $mini_content, $headers);
                            }
                        }
                    }
                }
				$blnUserEmailSent = true;
			}
			Util::sendMailCore($arrAgent['booking_email'], $subject, $mini_content, $headers);
		}

        echo '{"respnose":"mail sent"}';
    }

}else if($action == 'sendQuoteLink') {

	//http://bcgolfguide.nav/application/ajax.php?action=sendQuoteLink&packageID=8256&mini_content=test

	$mini_content = (isset($_REQUEST['mini_content']) ? $_REQUEST['mini_content'] : '');
	$quoteID = (isset($_REQUEST['quoteID']) ? $_REQUEST['quoteID'] : '');
    $mini_content = wordwrap($mini_content, 900);

	if($mini_content != '') {
		// include(ROOT_DIR.'/application/models/admin/quote.php');
		include(ROOT_DIR.'/application/models/admin/brand.php');

		$objQuote = new Quote;
		$objBrand = new Brand;

		$admin_email =  'ross@bcgolfguide.com'; // Default
		$user_email =  ''; // Customer can't have default
		$intBrandId = 18; // Default BCgolfGuide

		$arrAgents =  $objQuote->getEmailsForQuote($quoteID);

		// Determine Primary Contact
		foreach ($arrAgents as $arrAgent) {

			$user_email = $arrAgent['user_email'];
			$intBrandId = $arrAgent['brandID'];

			if ($arrAgent['primary_contact'] == '1') {
				$admin_email = $arrAgent['booking_email'];
			}
		}

		$arrBrand = $objBrand->getDetail($intBrandId);
        $subject = 'Message from ' . $arrBrand['business_name'];

		// Send Email to all Agents
		foreach ($arrAgents as $arrAgent) {
			// Send the admin email
        	Util::sendMail($arrAgent['booking_email'], $subject, $mini_content, '', 'Content-Type: text/html; charset=UTF-8' . "\r\n");
		}

        // Send tracking email to the user
        Util::sendTrackingMail(array(
            'to' => $user_email,
            'from' => $admin_email,
            'subject' => $subject,
            'message' => $mini_content,
            'headers' => 'Content-Type: text/html; charset=UTF-8' . "\r\n",
            'tracking_data' => array(
                'action' => 'quote_email_notice',
                'quote_id' => $quoteID
            )
        ));



        echo '{"respnose":"mail sent"}';
	}

} else if($action == 'sendPackageVoucherLink') {

	//http://bcgolfguide.nav/application/ajax.php?action=sendPackageVoucherLink&packageID=8256&mini_content=test

	$strContent = (isset($_REQUEST['voucherContent']) ? $_REQUEST['voucherContent'] : '');
    $strContent = wordwrap($strContent, 900);
	$intPackageId = (isset($_REQUEST['packageID']) ? $_REQUEST['packageID'] : '');

	if($strContent != '') {
		include(ROOT_DIR.'/application/models/admin/package.php');
		include(ROOT_DIR.'/application/models/admin/brand.php');

		$objPackage = new Package;
		$objBrand = new Brand;

		$arrAgents =  $objPackage->getEmailsForPackage($intPackageId);
		$blnUserEmailSent = false;
		$strPrimaryContact = 'Ross Marrington';
		$strPrimaryContactEmail = 'ross@bcgolfguide.com';

		foreach ($arrAgents as $arrAgent) {
			if ($arrAgent['primary_contact'] == '1') {
				$strPrimaryContact = $arrAgent['booking_name'];
				$strPrimaryContactEmail = $arrAgent['booking_email'];
			}
		}

		foreach ($arrAgents as $arrAgent) {

			$semi_rand     = md5(time());
			$mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";
	    	$headers = "From: ".$strPrimaryContactEmail. "\r\n" .
	    		'Reply-To: '.$strPrimaryContactEmail. "\r\n" .
	    		'Content-Type: text/html; charset=UTF-8' . "\r\n" .
	    		'X-Mailer: PHP/' . phpversion();

	    	$arrBrand = $objBrand->getDetail($arrAgent['brandID']);

	        $subject = 'Message from ' . $arrBrand['business_name'];

			if (!$blnUserEmailSent) {
				Util::sendMailCore($arrAgent['user_email'], $subject, $strContent, $headers);
				$blnUserEmailSent = true;
			}

	        Util::sendMailCore($arrAgent['booking_email'], $subject, $strContent, $headers);
	    }

        echo '{"respnose":"mail sent"}';
	}


} else if($action == 'sendHotelNotice') {



	//http://preview.bcgolfguide.com/application/ajax.php?action=sendHotelNotice&relhotelID=2508&email_content=test

	$email_content = (isset($_REQUEST['email_content']) ? nl2br($_REQUEST['email_content']) : '');
	$relhotelID = (isset($_REQUEST['relhotelID']) ? $_REQUEST['relhotelID'] : '');
	$packageID = (isset($_REQUEST['packageID']) ? $_REQUEST['packageID'] : '');

	if($email_content != '') {

		//echo "relhotelID=".$relhotelID;


		include(ROOT_DIR.'/application/models/admin/package.php');
		$objPackage = new Package;

		$result =  $objPackage->getEmailsForPackageHotel($relhotelID);
		$hotel_email =  $result['hotel_email'];
  		$business_name = $result['business_name'];

		$strPrimaryContact = 'Ross Marrington';
		$strPrimaryContactEmail = 'ross@bcgolfguide.com';

		$arrAgents = $objPackage->getEmailsForPackage($packageID);

		foreach ($arrAgents as $arrAgent) {
			if ($arrAgent['primary_contact'] == '1') {
				$strPrimaryContact = $arrAgent['booking_name'];
				$strPrimaryContactEmail = $arrAgent['booking_email'];
			}
		}

		$semi_rand     = md5(time());
		$mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";
    	$headers = "From: ".$strPrimaryContactEmail. "\r\n" .
    		'Reply-To: '.$strPrimaryContactEmail. "\r\n" .
    		'X-Mailer: PHP/' . phpversion();
    	$subject = 'Message from '.$business_name;

		// Send to all contacts on the package
		foreach ($arrAgents as $arrAgent) {
			Util::sendMailCore($arrAgent['booking_email'], $subject, $email_content, $headers);
		}

		// Send to hotel
        Util::sendMailCore($hotel_email, $subject, $email_content, $headers);

        echo '{"response":"mail sent"}';

       // echo json_encode($objPackage->getNotesForPackage($packageID));

	}

} else if($action == 'refreshHotelNotice') {


//http://bcgolfguide.nav/application/ajax.php?action=refreshHotelNotice&relhotelID=2484


	$relhotelID = (isset($_REQUEST['relhotelID']) ? $_REQUEST['relhotelID'] : '');
	include(ROOT_DIR.'/application/models/admin/package.php');
	$objPackage = new Package;

	$result =  $objPackage->getEmailsForPackageHotel($relhotelID);
	$admin_email =  $result['contact_email'];
	$hotel_email =  $result['hotel_email'];
	$strMiniContent =  $result['mini_hotel_text'];
	$intRooms =  $result['rooms'];
	$intNights =  $result['nights'];
	$strConfirmNum =  $result['confirm_num'];
	$strCheckInDate =  $result['check_in_date'];
	$strCheckOutDate =  $result['check_out_date'];
	$strGroupName =  $result['group_name'];
	$strPhone =  $result['phone'];
	$strCellPhone =  $result['cell_phone'];

	$arrDetails = $objPackage->getPackageHotelDetail($relhotelID,false);

	//echo '<pre>';
	//var_dump($arrDetails);


	$strMiniContent = str_replace('[arrival]',$strCheckInDate,$strMiniContent);
	$strMiniContent = str_replace('[depart]',$strCheckOutDate,$strMiniContent);
	$strMiniContent = str_replace('[room_num]',$intRooms,$strMiniContent);
	$strMiniContent = str_replace('[confirm_num]',$strConfirmNum,$strMiniContent);
	$strMiniContent = str_replace('[group_name]',$strGroupName,$strMiniContent);
	$strMiniContent = str_replace('[phone_1]',Util::formatPhone($strPhone),$strMiniContent);
	$strMiniContent = str_replace('[phone_2]',Util::formatPhone($strCellPhone),$strMiniContent);

	$strRoomList = '';
	$i = 0;
	for($x = 1;$x<=count($arrDetails);$x++) {

        $people_name = isset($arrDetails[$i]['people_name']) ? $arrDetails[$i]['people_name'] : 'Player';
        $people_lname = isset($arrDetails[$i]['people_lname']) ? $arrDetails[$i]['people_lname'] : $x;
        $people_email = isset($arrDetails[$i]['people_email']) ? $arrDetails[$i]['people_email'] : '';
        $room_num = isset($arrDetails[$i]['room_num']) ? $arrDetails[$i]['room_num'] : '';
		$room_reservation_num = isset($arrDetails[$i]['room_reservation_num']) ? $arrDetails[$i]['room_reservation_num'] : '';

        $strRoomList .= 'Room '.$room_num.' - '.$people_name.' '.$people_lname.' - ' . $room_reservation_num . ''."\r\n";

        $i++;

    }

	$strMiniContent = str_replace('[room_detail]',$strRoomList,$strMiniContent);

	echo $strMiniContent;


} else if($action == 'refreshQuoteHotelNotice') {


//http://bcgolfguide.nav/application/ajax.php?action=refreshHotelNotice&relhotelID=2484


	$relhotelID = (isset($_REQUEST['relhotelID']) ? $_REQUEST['relhotelID'] : '');
	// include(ROOT_DIR.'/application/models/admin/quote.php');
	$objQuote = new Quote;

	$result =  $objQuote->getEmailsForQuoteHotel($relhotelID);
	$admin_email =  $result['contact_email'];
	$hotel_email =  $result['hotel_email'];
	$strMiniContent =  $result['mini_hotel_text'];
	$intRooms =  $result['rooms'];
	$intNights =  $result['nights'];
	$strConfirmNum =  $result['confirm_num'];
	$strCheckInDate =  $result['check_in_date'];
	$strCheckOutDate =  $result['check_out_date'];
	$strGroupName =  $strGroupName = Quote::getGroupName($result['quote_id']);
	$strPhone =  $result['phone'];
	$strCellPhone =  $result['cell_phone'];


	$arrDetails = $objQuote->getQuoteHotelDetail($relhotelID,false);

	// echo '<pre>';
	// var_dump($arrDetails);
	// die();

	$strMiniContent = str_replace('[arrival]',$strCheckInDate,$strMiniContent);
	$strMiniContent = str_replace('[depart]',$strCheckOutDate,$strMiniContent);
	$strMiniContent = str_replace('[room_num]',$intRooms,$strMiniContent);
	$strMiniContent = str_replace('[confirm_num]',$strConfirmNum,$strMiniContent);
	$strMiniContent = str_replace('[group_name]',$strGroupName,$strMiniContent);
	$strMiniContent = str_replace('[phone_1]',Util::formatPhone($strPhone),$strMiniContent);
	$strMiniContent = str_replace('[phone_2]',Util::formatPhone($strCellPhone),$strMiniContent);

	$strRoomList = '';
	$i = 0;
	for($x = 1;$x<=count($arrDetails);$x++) {

        $people_name = isset($arrDetails[$i]['people_name']) ? $arrDetails[$i]['people_name'] : 'Player';
        $people_lname = isset($arrDetails[$i]['people_lname']) ? $arrDetails[$i]['people_lname'] : $x;
        $people_email = isset($arrDetails[$i]['people_email']) ? $arrDetails[$i]['people_email'] : '';
        $room_num = isset($arrDetails[$i]['room_num']) ? $arrDetails[$i]['room_num'] : '';
        $room_reservation_num = isset($arrDetails[$i]['room_reservation_num']) ? $arrDetails[$i]['room_reservation_num'] : '';


        $strRoomList .= 'Room '.$room_num.' - '.$people_name.' '.$people_lname.' - ' . $room_reservation_num . ''."\r\n";
        $i++;

    }

	$strMiniContent = str_replace('[room_detail]',$strRoomList,$strMiniContent);

	echo $strMiniContent;


} else if($action == 'courseDisplay') {

	//http://bcgolfguide.nav/application/ajax.php?action=courseDisplay&courses={\"id\":\"2\",\"id\":\"25\"}
	$courses = (isset($_REQUEST['courses']) ? $_REQUEST['courses'] : '');

	if($courses != '') {

		$objPartner = new Partner();
		$arrCourses = json_decode($courses,true);



		if(count($arrCourses) > 0){

			$na = array();
			foreach($arrCourses As $c) {
				$na[] = $c['id'];
			}





			$objPartner->getCoursesForBuilder($na);

		}
	}

} else if($action == 'hotelDisplay') {

	//http://bcgolfguide.nav/application/ajax.php?action=hotelDisplay&hotels={\"id\":\"2\",\"id\":\"25\"}
	$hotels = (isset($_REQUEST['hotels']) ? $_REQUEST['hotels'] : '');

	if($hotels != '') {

		$objPartner = new Partner();
		$arrHotels = json_decode($hotels,true);
		if(count($arrHotels) > 0){
			$na = array();
			foreach($arrHotels As $h) {
				$na[] = $h['id'];
			}


			$objPartner->getHotelsForBuilder($na);
		}
	}

} else if($action == 'deletePDF') {

	//http://preview.bcgolfguide.com/application/ajax.php?action=deletePDF&packageID=8414
	//http://bcgolfguide.nav/application/ajax.php?action=deletePDF&packageID=8414
	$packageID = (isset($_REQUEST['packageID']) ? $_REQUEST['packageID'] : '');
 	$strPDF = '/application/uploads/pdfs/'.$packageID.'_voucher.pdf';

	if (Util::isFile($strPDF)) {
//die('here');
		echo "deleted ".$packageID.'_voucher.pdf';
		unlink(ROOT_DIR.$strPDF);
	} else {
		echo "not found ".$strPDF;
	}



} else if($action == 'generatePDF') {

	include(ROOT_DIR.'/application/models/admin/package.php');
	$objPackage = new Package;
	$packageID = (isset($_REQUEST['packageID']) ? $_REQUEST['packageID'] : '');


	$url_voucher = ROOT_URL."/application/services/print_voucher.php?package_id=" . $packageID;
	####Creat PDF with voucher
	$pdf = '/application/uploads/pdfs/'.$packageID.'_voucher.pdf';
	$filePath = ROOT_DIR.$pdf;
	$logo =  ROOT_DIR.'/application/uploads/voucher/spacer.gif';

	echo 'url_voucher='.$url_voucher.'<br />'."\n";
	echo 'filePath='.$filePath.'<br />'."\n";
	echo 'logo='.$logo.'<br />'."\n";

	$options = "-f ".$filePath." --strict --footer ./. --size a4 --left 0.5in --right 0.5in --bodyfont times --browserwidth 720px --fontsize 9.0 --top 0in --bottom 0.5in --header l --logoimage ".$logo."";

    $ch = curl_init("https://services.bcgolfguide.com/?package_id=" . $packageID);
    curl_exec($ch);
    curl_close($ch);

    //$objPackage->topdf($url_voucher, $options);

	if (file_exists(ROOT_DIR.$pdf)) {
		echo "generatePDF - success"."\n";
	} else {
		echo "generatePDF - fail"."\n";
	}

} else if($action == 'lookupMember') {


	//http://bcgolfguide.nav/application/ajax.php?action=lookupMember&email=kirkw@navigatormm.com

	include(ROOT_DIR.'/application/models/admin/member.php');
	$objMember = new Member();

	$email = (isset($_REQUEST['email']) ? $_REQUEST['email'] : '');
	//$packageID = (isset($_REQUEST['packageID']) ? $_REQUEST['packageID'] : '');

	$arrDetails = $objMember->getDetailByEmail($email);

	echo json_encode($arrDetails);

} else if($action == 'quickContact') {

	if (!empty($_REQUEST['values'])) {
		$arrValues = array();
		$arrErrors = array();
		$arrResponse = array();
		parse_str($_REQUEST['values'], $arrValues);

		// Validation
		if (empty($arrValues['book_name']))  {
			$arrErrors[] = 'Please type your name.';
		}
		if (empty($arrValues['book_email'])) {
			$arrErrors[] = 'Please type your email.';
		}

		if (empty($arrValues['book_phone'])) {
			$arrErrors[] = 'Please type your phone number.';
		}

		if (!empty($arrValues['book_email']) && filter_var($arrValues['book_email'], FILTER_VALIDATE_EMAIL) === false) {
			$arrErrors[] = 'Please type a valid email address.';
		}
		if (!empty($arrValues['book_website'])) {
			// This is our bot bait field, it's hidden to a normal user
			// So if it has a value then a bot filled it out
			$arrErrors[] = 'An error occurred, please try again later.';
		}

		// Return the errors
		if (!empty($arrErrors)) {
			$arrResponse['success'] = false;
			$arrResponse['message'] = implode('<br>', $arrErrors);
		} else {
			$strTo 		= $objSettings->strAdminEmail;
			$strCC		= 'danny@bcgolfguide.com';
			$strFrom 	= $arrValues['book_name'].' <'.$arrValues['book_email'].'>';
			$strSubject = 'New Quick Contact Message';
			$strMessage = '<strong>Name:</strong> '.$arrValues['book_name']
						. '<br><strong>Email:</strong> '.$arrValues['book_email']
						. '<br><strong>Phone:</strong> '.$arrValues['book_phone']
						. '<br><strong>URL:</strong> '.$arrValues['book_url'];

			// Send off the email
			$blnSent = Util::sendMail($strTo, $strSubject, $strMessage, $strFrom);
			$blnSent2 = Util::sendMail($strCC, $strSubject, $strMessage, $strFrom);
			$strMessage .= "Your email request to BCgolfguide.com has been sent, and a golf travel agent will respond to your needs today. (Note: Our reply back maybe the next day if after regular business hours or if on weekends we will attempt to call as soon as possible)";
			$blnSent3 = Util::sendMail($arrValues['book_email'], $strSubject, $strMessage, $strFrom);
			// Return our response based on if it sent successfully
			if ($blnSent) {
				$arrResponse['success'] = true;
				$arrResponse['message'] = 'Thank you, the email was sent successfully';
			} else {
				$arrResponse['sucess'] = false;
				$arrResponse['message'] = 'Sorry, something went wrong while sending the email, please try again later';
			}
		}

		echo json_encode($arrResponse);

	}

	die;

} else if($action == 'helpRequest') {

	$help_name = (isset($_REQUEST['help_name']) ? $_REQUEST['help_name'] : '');
	$help_email = (isset($_REQUEST['help_email']) ? $_REQUEST['help_email'] : '');
	$help_phone = (isset($_REQUEST['help_phone']) ? $_REQUEST['help_phone'] : '');
	$help_comment = (isset($_REQUEST['help_comment']) ? $_REQUEST['help_comment'] : '');
	$session_id = (isset($_REQUEST['session']) ? $_REQUEST['session'] : '');


	include(ROOT_DIR.'/application/models/admin/package.php');
	$objPackage = new Package;
	$arrDetails =  $objPackage->getDetail('',$session_id);

	$arrAgents = $objPackage->getEmailsForPackage($arrDetails['id']);

	$strPrimaryContact = 'Ross Marrington';
	$strPrimaryContactEmail = 'ross@bcgolfguide.com';

	$strGroupName = $objPackage->strGroupName;
	$strBrandName = $objPackage->strBrandName;
	$intId = $objPackage->intId;
	$strTo 		= $help_email;

	$strSubject = 'Name change / Payment help request for group <'.$strBrandName.'>';

	$strMessage = '<strong>Name:</strong> '.$help_name
		. '<br><strong>Email:</strong> '.$help_email
		. '<br><strong>Phone:</strong> '.$help_phone
		. '<br><strong>Comment:</strong> '.$help_comment;

	$strBrandMessage = $strMessage
		. '<br /><strong>Group Name:</strong> <a href="' . ROOT_URL . '/admin/package/edit/' . $arrDetails['id'] . '/">' . $strGroupName . '</a>';

	$blnSent = true;
	foreach ($arrAgents As $arrAgent) {
		if (!Util::sendMail($arrAgent['booking_email'], $strSubject, $strBrandMessage, $help_email)) {
			$blnSent = false;
		}
	}

	//$strCC1		= 'ross@bcgolfguide.com';
	//$strCC2		= $objPackage->strUserEmail;
	//$strCC3		= $objPackage->strBookingEmail;

/*
	$strFrom 	= $strBrandName.' <'.$strCC3.'>';

	if(!empty($arrBrand['contact_email'])){
		$strFrom = $arrBrand['contact_email'];
	}
	*/



	//$blnSent = Util::sendMail($strTo, $strSubject, $strMessage, $strFrom);
	//$blnSent3 = Util::sendMail($strCC2, $strSubject, $strMessage, $strFrom);
/*
	if($strCC3 != $strCC1){
		//$blnSent4 = Util::sendMail($strCC3, $strSubject, $strMessage, $strFrom);
	}
*/

	if ($blnSent) {
		$arrResponse['success'] = true;
		$arrResponse['message'] = 'Thank you, the email was sent successfully';
	} else {
		$arrResponse['success'] = false;
		$arrResponse['message'] = 'Sorry, something went wrong while sending the email, please try again later';
	}

	echo json_encode($arrResponse);

	die;

} else if($action == 'getBrandHotels') {
	$arrReturn = array(
		'blnError' => false,
		'strMessage' => null,
		'arrHotels' => array()
	);

	if(!isset($_REQUEST['brandId']) || empty($_REQUEST['brandId'])){
		// no brand ID passed in
		$arrReturn['strMessage'] = 'No hotels for brand with id: ' . $_REQUEST['brandId'];
		echo json_encode($arrReturn);
		die();
	}

	// get the brand id
	$intBrandId = (int)$_REQUEST['brandId'];

	// get the brand Hotels
	include(ROOT_DIR . '/application/models/admin/brand.php');

	$arrHotels = Brand::getHotelsByBrand($intBrandId);

	if(empty($arrHotels)){
		// no Hotels for this brand
		$arrReturn['strMessage'] = 'No hotels for brand with id: ' . $_REQUEST['brandId'];
		echo json_encode($arrReturn);
		die();
	}

	$arrReturn['arrHotels'] = $arrHotels;

	// return the Hotels
	echo json_encode($arrReturn);
	die();

} else if($action == 'getBrandCourses') {
	$arrReturn = array(
		'blnError' => false,
		'strMessage' => null,
		'arrCourses' => array()
	);

	if(!isset($_REQUEST['brandId']) || empty($_REQUEST['brandId'])){
		// no brand ID passed in
		$arrReturn['strMessage'] = 'No Courses for brand with id: ' . $_REQUEST['brandId'];
		echo json_encode($arrReturn);
		die();
	}

	// get the brand id
	$intBrandId = (int)$_REQUEST['brandId'];

	// get the brand Hotels
	include(ROOT_DIR . '/application/models/admin/brand.php');

	$arrCourses = Brand::getCoursesByBrand($intBrandId);

	if(empty($arrCourses)){
		// no Hotels for this brand
		$arrReturn['strMessage'] = 'No Courses for brand with id: ' . $_REQUEST['brandId'];
		echo json_encode($arrReturn);
		die();
	}

	$arrReturn['arrCourses'] = $arrCourses;

	// return the Hotels
	echo json_encode($arrReturn);
	die();

} else if($action == 'duplicate_package_hotel'){
	$arrReturn = array(
		'error' => false,
		'message' => null
	);

	if(!isset($_GET['duplicate_hotel_id']) || empty($_GET['duplicate_hotel_id']) || !isset($_GET['package_hotel_id']) || empty($_GET['package_hotel_id'])){
		$arrReturn['error'] = true;
		$arrReturn['message'] = '<strong>An Error Occurred.</strong> Required information is not included.';
		echo json_encode($arrReturn);
		die();
	}

	$intPackageHotelId = $_GET['package_hotel_id'];
	$intNewHotelId = $_GET['duplicate_hotel_id'];

	include(ROOT_DIR.'/application/models/admin/package_hotel.php');
	$intNewPackageHotelId = PackageHotels::duplicate($intPackageHotelId, $intNewHotelId);

	if(!is_int($intNewPackageHotelId)){
		// error duplicating
		$arrReturn['error'] = true;
		$arrReturn['message'] = '<strong>An Error Occurred.</strong> ' . $intNewPackageHotelId; // error message
		echo json_encode($arrReturn);
		die();
	}

	// successfully duplicated
	$arrReturn['newPackageId'] = $intNewPackageHotelId;

	echo json_encode($arrReturn);
	die();

} else if($action == 'sendTeeTimesUpdateEmail'){
	$arrForm = $_REQUEST;

	$strTeeDateTime = '';
	if(!empty($arrForm['tee_date']) && $arrForm['tee_date'] != '0000-00-00'){
		$strTeeDateTime = date('Y-m-d g:ia', strtotime($arrForm['tee_date'] . ' ' . $arrForm['tee_time'] . ' ' . $arrForm['tee_ap']));
	}

	$intNumberOfGolfers = $arrForm['golfer_num'];

	// get group name and brandID
	include(ROOT_DIR . '/application/models/admin/package.php');
	include(ROOT_DIR . '/application/models/admin/brand.php');
	include(ROOT_DIR . '/application/models/admin/package_golf.php');
	// include(ROOT_DIR . '/application/models/admin/course.php');

	$objPackage = new Package;
	$objBrand = new Brand;
	$objCourse = new Course;
	$objPackageCourse = new Packagecourses;

	$arrPackage = $objPackage->getByID($arrForm['packageID']);
	$strGroupName = $arrPackage['group_name'];

	$arrBrand = $objBrand->getByID($arrPackage['brandID']);

	$arrPackageCourse = $objPackageCourse->getByID($arrForm['relCourseID']);
	$arrCourse = $objCourse->getByID($arrPackageCourse['course_id']);
	$strCourseTeeTimeEmail = $arrCourse['teetimes_email'];

	// make email content
	$strContent = $arrForm['course_teetimes_update_email'];

	$strContent = str_replace('[tee_time]', $strTeeDateTime, $strContent);
	$strContent = str_replace('[group_name]', $strGroupName, $strContent);
	$strContent = str_replace('[golfer_count]', $intNumberOfGolfers, $strContent);
	$strContent = str_replace('[course_name]', $arrCourse['course_name'], $strContent);
	$strContent = str_replace('[brand_name]', $arrBrand['business_name'], $strContent);

	$strContent = nl2br($strContent);

	$strHeaders = "MIME-Version: 1.0\r\n";
    $strHeaders .= "Content-Type: text/html; charset=ISO-8859-1\r\n";

    $strSubject = $strGroupName . ' t-time request change';

    $strPrimaryContact = 'Ross Marrington';
    $strPrimaryContactEmail = 'ross@bcgolfguide.com';

    $arrAgents = $objPackage->getEmailsForPackage($arrForm['packageID']);

    foreach ($arrAgents as $arrAgent) {
    	if ($arrAgent['primary_contact'] == '1') {
    		$strPrimaryContact = $arrAgent['booking_name'];
    		$strPrimaryContactEmail = $arrAgent['booking_email'];
    	}
    }


	// email course tee times person
    $strUserHeaders = "From: " . strip_tags($strPrimaryContactEmail) . "\r\n"
                 . "Reply-To: ". strip_tags($strPrimaryContactEmail) . "\r\n"
                 . $strHeaders;

	if(!Util::sendMailCore($strCourseTeeTimeEmail, $strSubject, $strContent, $strUserHeaders)){
		// email didn't sent
		echo json_encode(array(
			'blnError' => true,
			'strMessage' => '<strong>An Error Occurred.</strong> The email was not sent. Please try again.'
		));

		die();
	}

	// email a copy to package contacts
	foreach ($arrAgents as $arrAgent) {
		$strBrandContactHeaders = "From: " . $strPrimaryContactEmail . "\r\n"
                         . "Reply-To: ". $strPrimaryContactEmail . "\r\n"
                         . $strHeaders;
        Util::sendMailCore($arrAgent['booking_email'], $strSubject, $strContent, $strBrandContactHeaders);
	}

    echo json_encode(array(
		'blnError' => false,
		'strMessage' => '<strong>Email Sent Successfully.</strong>'
	));

	die();


} else if($action == 'filterByRegions'){
    // Include the admin rate model
    include(ROOT_DIR.'/application/models/admin/rates.php');

    // Response data
    $arrResponse = array(
        'error' => false,
        'message' => null,
        'data' => null,
    );

    // Set varibles sent by js
    $arrRegions = $_REQUEST['regions'];

    if (empty($arrRegions)) {
        // No regions were selected
        $arrResponse['error'] = true;
        $arrResponse['message'] = 'No regions were selected.';
        echo json_encode($arrResponse); die;
    }

    // Get the data
    $arrHotels  = Rate::getHotels(array('regions' => $arrRegions));
    $arrCourses = Rate::getCourses(array('regions' => $arrRegions));

    // There's an issue with the data having invalid UTF8 characters which
    // makes the json_encode return false, so we're going to sanitize the data,
    // and return just what we need to the JS functions (ids)

    // Set our response data
    $arrResponse['message'] = 'Success';
    $arrResponse['data'] = array(
        'hotels' => array_column($arrHotels, 'id'),
        'courses' => array_column($arrCourses, 'id'),
    );

    // Parse the data
    $a = json_encode($arrResponse);

    // Invalid JSON
    if (!$a) {
        $arrResponse['error'] = true;
        $arrResponse['message'] = 'Invalid data was returned.';
        $arrResponse['data'] = array();
        echo json_encode($arrResponse); die;
    }

    // Output our response
    echo json_encode($arrResponse); die;

} else if($action == 'getRates') {
    // Include the admin rate model
    include(ROOT_DIR.'/application/models/admin/rates.php');

    // Response data
    $arrResponse = array(
        'error' => false,
        'message' => null,
        'data' => null,
    );

    // Set varibles sent by js
    $strData = $_REQUEST['data'];
    parse_str($strData, $arrData);

    // Make sure data was sent
    if (empty($arrData)) {
        $arrResponse['error'] = true;
        $arrResponse['message'] = 'No Data sent.';
        echo json_encode($arrResponse); die;
    }

    // Set variables
    $strDateStart = !empty($arrData['date_start']) ? $arrData['date_start'] : '';
    $strDateEnd = !empty($arrData['date_end']) ? $arrData['date_end'] : '';

    if ($strDateStart != '') {

    	//$objDate = new DateTime($strDateStart);
    	//$strStartYear = $objDate->format('Y');
    	//$strMinStart = date($strStartYear . '-01-01');
    	$strMinStart = $strDateStart;
    } else {
    	$strMinStart = '';
    }

    if ($strDateEnd != '') {

    	//$objDate = new DateTime($strDateEnd);
    	//$strEndYear = $objDate->format('Y');
    	//$strMaxEnd = date(($strEndYear + 1) . '-01-01');
    	$strMaxEnd = $strDateEnd;
    } else {
    	$strMaxEnd = '';
    }

    $arrHotels = !empty($arrData['hotels']) ? $arrData['hotels'] : array();
    $arrCourses = !empty($arrData['courses']) ? $arrData['courses'] : array();
    $strHtmlHotels = 'No rates found.';
    $strHtmlCourses = 'No rates found.';
    $arrRatesHotels = array();
    $arrRatesCourses = array();

    // Make an array of all selected rates
    $arrRatesSelectedHotels = !empty($arrData['rates_hotels']) ? $arrData['rates_hotels'] : array();
    $arrRatesSelectedCourses = !empty($arrData['rates_courses']) ? $arrData['rates_courses'] : array();

    $arrRatesPostedHotels = !empty($arrData['rates_selected_hotels']) ? json_decode($arrData['rates_selected_hotels'], true) : array();
    $arrRatesPostedCourses = !empty($arrData['rates_selected_courses']) ? json_decode($arrData['rates_selected_courses'], true) : array();

    // Overwrite the selected courses if they have been posted
    if (!empty($arrRatesPostedHotels)) {
        $arrRatesSelectedHotels = $arrRatesPostedHotels;
    }

    // Overwrite the selected courses if they have been posted
    if (!empty($arrRatesPostedCourses)) {
        $arrRatesSelectedCourses = $arrRatesPostedCourses;
    }

    if (!empty($arrHotels)) {
        foreach ($arrHotels as $intId) {
            // Get the rates

        	$args = array('hotel_id'=>$intId);



            $arrRates = Rate::getHotelRates(array(
                'hotel_id' => $intId,
                'min_start_date' => $strMinStart,
                //'min_start_date' => $strDateStart,
                //'max_start_date' => $strDateStart,
                //'min_end_date' => $strDateEnd,
                //'max_end_date' => $strDateEnd,
                'max_end_date' => $strMaxEnd,
            ));

            if (!empty($arrRates)) {
                // Add the rates
                $arrRatesHotels[$intId] = $arrRates;
            }
        }
    }

    if (!empty($arrCourses)) {
        foreach ($arrCourses as $intId) {
            // Get the rates
            $arrRates = Rate::getCourseRates(array(
                'course_id' => $intId,
                 'min_start_date' => $strMinStart,
                //'min_start_date' => $strDateStart,
                //'max_start_date' => $strDateStart,
                //'min_end_date' => $strDateEnd,
                //'max_end_date' => $strDateEnd,
                'max_end_date' => $strMaxEnd,

            ));

            if (!empty($arrRates)) {
                // Add the rates
                $arrRatesCourses[$intId] = $arrRates;
            }
        }
    }

    if (!empty($arrRatesHotels)) {
        ob_start();
        // Get the rates view
        include(ROOT_DIR . '/application/views/admin/rates/_hotel_rates.php');
        $strHtmlHotels = ob_get_clean();
    }

    if (!empty($arrRatesCourses)) {
        ob_start();
        // Get the rates view
        include(ROOT_DIR . '/application/views/admin/rates/_course_rates.php');
        $strHtmlCourses = ob_get_clean();
    }

    // Set our return data

    //NOTE: somehow illegal non UTF-8 characters got into the rate descriptions
    //A workaround is to filter them out using the iconv function
    //Display errors must be turned off for this because the //IGNORE flag does not work correctly and this will generate a notice if it finds offending characters
    ini_set('display_errors', 0);

    $arrResponse['data'] = array(
        'rates_hotels' => $arrRatesHotels,
        'rates_courses' => $arrRatesCourses,
        'rates_selected_hotels' => $arrRatesSelectedHotels,
        'rates_selected_courses' => $arrRatesSelectedCourses,
        //'html_hotels' => $strHtmlHotels,
        'html_hotels' => iconv('UTF-8', 'UTF-8//IGNORE', $strHtmlHotels),
        //'html_courses' => $strHtmlCourses
        'html_courses' => iconv('UTF-8', 'UTF-8//IGNORE', $strHtmlCourses)
    );

    // Output our response
    echo json_encode($arrResponse); die;

} elseif ($action == 'filterCourses') {

    $arrReturn = array(
        'error' => false,
        'message' => '',
        'html' => '',
        'pages' => 1,
        'page' => 1,
    );

    // Set the data
    parse_str($_REQUEST['data'], $arrData);

    // Get the courses
    $objModel = new Course;
    $arrCourses = $objModel->getCourseListbyRegion(array(
        'region' => $arrData['course_region'],
        'state' => 2, // BC
        'search' => $arrData['course_search'],
        'page' => $arrData['course_page'],
        'order' => $arrData['course_sort'],
    ));

    // Exit if no course
    if (empty($arrCourses)) {
        $arrReturn['error'] = true;
        $arrReturn['message'] = 'No courses found.';
        echo json_encode($arrReturn); die;
    }

    $strHtml = '';
    $arrGroups = array_chunk($arrCourses, ceil(count($arrCourses) / 2));
    foreach ($arrGroups as $arrCourses) {
        $strHtml .= '<div class="course-group">';
        foreach ($arrCourses as $arrCourse) {
            $strHtml .= '<a class="course-result" href="/golf-courses/' . $arrCourse['slug'] . '/">'
                      . $arrCourse['course_name'] . '<small>' . $arrCourse['public_note'] . '</small>'
                      . '</a>';
        }
        $strHtml .= '</div>';
    }

    // Set the return data
    $arrReturn['html'] = $strHtml;
    $arrReturn['pages'] = $objModel->intPageCount;
    $arrReturn['page'] = $objModel->pg;

    // Echo the reponse
    echo json_encode($arrReturn); die;

} elseif ($action == 'mass_mail_email_list') {

    $objMailHelper = new Mass_Mailer();

    // Set the data
    $arrData = $_REQUEST['data'];

    $arrEmails = $objMailHelper->getEmailList($arrData, $_REQUEST['mailtype']);

    echo json_encode($arrEmails);
    die();
    //var_dump($arrData);
    //die();

} elseif ($action == 'mass_mail_email_test') {

    $objMailHelper = new Mass_Mailer();

    // Set the data
    $arrData = $_REQUEST['data'];
    $arrEmails = $objMailHelper->getEmailList($arrData, $_REQUEST['mailtype']);
    $blnSent = false;

    foreach ($arrEmails as $arrEmail) {

        //$strTo      = $arrEmail['user_email'];
        $strTo      = $_REQUEST['test_email'];
        $strFrom    = $arrEmail['booking_name'].' <'.$arrEmail['booking_email'].'>';
        $strSubject = 'A Message from BCGolfGuide.com';

        if ($_REQUEST['mailtype'] == 'Packages Mailer') {
            $strMessage = $_REQUEST['package_content'];
            $strSubject = $_REQUEST['package_subject'];
        }
        if ($_REQUEST['mailtype'] == 'Quotes Mailer') {
            $strMessage = $_REQUEST['quote_content'];
            $strSubject = $_REQUEST['quote_subject'];
        }

        $strSubject = str_replace('[user_name]', $arrEmail['user_name'], $strSubject);

        $strMessage = str_replace('[user_name]', $arrEmail['user_name'], $strMessage);
        $strMessage = str_replace('[group_name]', $arrEmail['group_name'], $strMessage);
        $strMessage = str_replace('[link]', $arrEmail['group_link'], $strMessage);

        // Send off the email
        $blnSent = Util::sendMail($strTo, $strSubject, $strMessage, $strFrom);

        break;
    }

    //if ($blnSent) {
        echo json_encode(array(true));
    //}

} elseif ($action == 'mass_mail_email_go') {

    $objMailHelper = new Mass_Mailer();

    // Set the data
    $arrData = $_REQUEST['data'];
    $arrEmails = $objMailHelper->getEmailList($arrData, $_REQUEST['mailtype']);
    $blnSent = false;

    ini_set('max_execution_time', 0);

    $arrBlnSent = array();

    foreach ($arrEmails as $arrEmail) {

        $strTo      = $arrEmail['user_email'];
        //$strTo      = $_REQUEST['test_email'];
        if ($arrEmail['booking_email'] == '') {
            $arrEmail['booking_email'] = 'ross@bcgolfguide.com';
        }

        $strFrom    = $arrEmail['booking_name'].' <'.$arrEmail['booking_email'].'>';

        $strSubject = 'A Message from BCGolfGuide.com';

        if ($_REQUEST['mailtype'] == 'Packages Mailer') {
            $strMessage = $_REQUEST['package_content'];
            $strSubject = $_REQUEST['package_subject'];
        }
        if ($_REQUEST['mailtype'] == 'Quotes Mailer') {
            $strMessage = $_REQUEST['quote_content'];
            $strSubject = $_REQUEST['quote_subject'];
        }

        $strSubject = str_replace('[user_name]', $arrEmail['user_name'], $strSubject);
        $strMessage = str_replace('[user_name]', $arrEmail['user_name'], $strMessage);

        $strMessage = str_replace('[group_name]', $arrEmail['group_name'], $strMessage);
        $strMessage = str_replace('[link]', $arrEmail['group_link'], $strMessage);

        // Send off the email to booking
        $blnSent = Util::sendMail($arrEmail['booking_email'], $strSubject, $strMessage, $strFrom);
        sleep(5);

        // Send to customer
        $blnSent = Util::sendMail($strTo, $strSubject, $strMessage, $strFrom);

        $arrBlnSent[] = array(
            'email' => $arrEmail['user_email'],
            'sent' => $blnSent,
        );
        sleep(10);
    }

    echo json_encode($arrBlnSent);
    die();

} else {

	echo "-no action";

}

?>
